/* File generated with Shader Minifier 1.1.4
 * http://www.ctrl-alt-test.fr
 */
#ifndef SHADER_CODE_H_
# define SHADER_CODE_H_

const char fsh_rayt[] =
 "uniform vec4 fpar[4];"
 "const float MAXDIST=500.,EPSILON=.01;"
 "const int MAXITER=200;struct RayResult{vec3 pos;vec3 normal;float dist;float mindist;float totaldist;};"
 "vec3 getC(float x,float k)"
 "{"
   "float y=clamp(1.-x,0.,1.);"
   "x=clamp(x,0.,1.);"
   "y*=k;"
   "return vec3(exp(-y*.1)+.2,exp(-y*.3),exp(-y*.7)).xyz*(1.-exp(-x*k));"
 "}"
 "float ss(float x)"
 "{"
   "return.5+.5*sin(x);"
 "}"
 "float sc(float x)"
 "{"
   "return.5+.5*cos(x);"
 "}"
 "float smin(float a,float b,float k)"
 "{"
   "float res=exp(-k*a)+exp(-k*b);"
   "return-log(res)/k;"
 "}"
 "vec3 rotZ(vec3 p,float a)"
 "{"
   "mat4 m=mat4(cos(a),sin(a),0.,0.,-sin(a),cos(a),0.,0.,0.,0.,1.,0.,0.,0.,0.,1.);"
   "return(m*vec4(p,1.)).xyz;"
 "}"
 "float boxZ(vec3 p,vec2 size)"
 "{"
   "return length(max(abs(p.xy)-size,0.));"
 "}"
 "float mesh(vec3 p,float size,float thick)"
 "{"
   "p=mod(p,size)-size*.5;"
   "float x=length(max(abs(p.yz)-vec2(size*thick),0.)),y=length(max(abs(p.xz)-vec2(size*thick),0.)),z=length(max(abs(p.xy)-vec2(size*thick),0.));"
   "return smin(x,smin(y,z,50.),50.)-thick*.1;"
 "}"
 "float sceneDist(vec3 p)"
 "{"
   "float deform=-pow(sc(p.x),5.)-pow(sc(p.y),5.),world=length(p)-(80.+deform);"
   "vec3 p2=p;"
   "p2+=vec3(sin(p.z*.1),cos(p.z*.1),0.);"
   "p2=rotZ(p2,.4*sin(p2.z*.4+fpar[0].y)+fpar[0].y);"
   "p2+=vec3(sin(p2.z*.1+fpar[0].y),cos(p2.z*.1),0.);"
   "p2+=2.*vec3(sin(fpar[0].y*.3),cos(fpar[0].y*.2),0.);"
   "p=rotZ(p,.4*sin(p.z*.4-fpar[0].y)+fpar[0].y);"
   "p=mix(p,p2,step(0.,p.z));"
   "float v1=mesh(p-vec3(0.,0.,fpar[0].y),.5,.08),b1=boxZ(p,vec2(2.,2.));"
   "return smin(max(b1,v1),world,.7);"
 "}"
 "vec3 getNormal(vec3 pos)"
 "{"
   "vec2 eps=vec2(0.,EPSILON);"
   "return normalize(vec3(sceneDist(pos+eps.yxx)-sceneDist(pos-eps.yxx),sceneDist(pos+eps.xyx)-sceneDist(pos-eps.xyx),sceneDist(pos+eps.xxy)-sceneDist(pos-eps.xxy)));"
 "}"
 "RayResult castRay(vec3 rPos,vec3 rDir)"
 "{"
   "RayResult result;"
   "result.dist=MAXDIST;"
   "result.mindist=MAXDIST;"
   "result.totaldist=0.;"
   "for(int i=0;i<MAXITER;i++)"
     "{"
       "if(result.dist<result.mindist)"
         "result.mindist=result.dist;"
       "if(result.dist<EPSILON||result.dist>MAXDIST)"
         "{"
           "continue;"
         "}"
       "result.dist=sceneDist(rPos);"
       "result.totaldist+=result.dist;"
       "rPos+=result.dist*rDir;"
     "}"
   "result.pos=rPos;"
   "result.normal=getNormal(result.pos);"
   "return result;"
 "}"
 "vec3 renderWorld(vec2 uv)"
 "{"
   "float t=fpar[0].y;"
   "vec3 camPos=fpar[1].xyz,camTarget=fpar[2].xyz,camDir=normalize(camTarget-camPos),camRight=normalize(cross(camDir,-normalize(fpar[3].xyz))),camUp=normalize(cross(camDir,camRight)),rayDir=normalize(camRight*uv.x+camUp*uv.y+camDir);"
   "RayResult ray=castRay(camPos,rayDir);"
   "vec3 c;"
   "if(ray.dist<EPSILON)"
     "{"
       "float surf=max(0.,dot(ray.normal,normalize(vec3(1.,1.,0.)))),direct=max(0.,dot(ray.normal,-camDir)),vDiffuse=mix(direct,surf,0.),burst=.6*pow(ss(ray.pos.z*.5105-fpar[0].y*3.14*fpar[0].w),5.+100.*(1.-smoothstep(80.1,82.,length(ray.pos))));"
       "c=getC(vDiffuse+burst,40.);"
     "}"
   "else"
     "{"
       "float lon=atan(rayDir.y/rayDir.x),lat=acos(rayDir.z),sky=pow(ss(lat*30.),8.)+pow(ss(lon*30.),8.);"
       "c=getC(1.-clamp(ray.mindist,0.,.95)+sky,5.);"
     "}"
   "return c;"
 "}"
 "void main()"
 "{"
   "vec2 uv=gl_TexCoord[0].xy;"
   "vec3 c=renderWorld(uv);"
   "float v=(1.-exp(5.5*length(uv)-6.))*fpar[0].z;"
   "gl_FragColor=vec4(c*v,1.);"
 "}";

#endif // SHADER_CODE_H_
